<?php
/**
 * Payment Gateway / Payments
 *
 * @var array|bool $payments
 * @var array $statuses
 * @var int $totalCount
 * @var int $count
 * @var int $page
 * @var int $totalPages
 * @var string $searchFilter
 * @package Mercury Payment Integration
 */
 ?>
<?php $this->load->view('partial/header'); ?>
<div id="paymentgateway">
    <div id="page_title" style="margin-bottom:8px;">Mercury Payment Gateway payments</div>
    <?php if (isset($error)) { ?><div class='error_message'><?php echo $error; ?></div><?php } ?>
    <?php if (isset($warning)) { ?><div class='warning_mesage'><?php echo $warning; ?></div><?php } ?>
    <?php if (isset($success)) { ?><div class='success_message'><?php echo $success; ?></div><?php } ?>
    <div id="page_body">
        <div class="description">
            Payments are listed below. Hover over columns to see value.
        </div>
        <form action="<?php echo base_url('index.php/PaymentGateway/payments/' . ($page - 1)); ?>" method="get">
            <fieldset>
                <div>
                    <p>
                        <label for="search_filter">Search</label>
                    </p>
                    <input type="text" name="search_filter" id="search_filter" value="<?php echo $searchFilter; ?>" />
                </div>
                <div>
                    <input type="submit" value="Search" />
                </div>
            </fieldset>
        </form>
        <table>
            <thead>
                <tr>
                    <th>Id</th>
                    <th>Payment Id</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Token</th>
                    <th>Sale</th>
                    <th>Status</th>
                    <th>Added</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tfoot>
                <tr>
                    <th>Id</th>
                    <th>Payment Id</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Token</th>
                    <th>Sale</th>
                    <th>Status</th>
                    <th>Added</th>
                    <th>Actions</th>
                </tr>
            </tfoot>
            <tbody>
                <?php if (isset($payments) && is_array($payments) && sizeof($payments) > 0) { ?>
                <?php foreach ($payments as $payment) { ?>
                <tr>
                    <td><?php echo $payment['request_payment_id']; ?></td>
                    <td><?php echo (!empty($payment['request_payment_paymentid']) ? '<strong title="' . $payment['request_payment_paymentid'] . '">Yes</strong>' : '-'); ?></td>
                    <td><?php echo $payment['request_payment_type']; ?></td>
                    <td><?php echo to_currency($payment['request_payment_amount']); ?></td>
                    <td><?php echo (isset($payment['request_payment_token']) ? '<strong title="' . $payment['request_payment_token'] . '">Yes</strong>' : '-'); ?></td>
                    <td><?php echo (isset($payment['request_payment_sale_id']) ? $payment['request_payment_sale_id'] : '-'); ?></a></td>
                    <td><?php echo (isset($statuses[$payment['request_payment_status']]) ? '<strong title="' . $statuses[$payment['request_payment_status']] . '">' . $payment['request_payment_status'] . '</strong>' : $payment['request_payment_status']); ?></td>
                    <td><?php echo substr($payment['request_payment_added'], 0, 10); ?></td>
                    <td>
                        <a href="<?php echo base_url('index.php/PaymentGateway/deletePayment/' . $payment['request_payment_id']); ?>" target="_blank">Delete</a>
                        <?php if (isset($payment['request_payment_token']) && $payment['request_payment_status'] == 4) { ?>
                        &nbsp;|&nbsp;
                        <a href="<?php echo base_url('index.php/PaymentGateway/returnSale/' . $payment['request_payment_id']); ?>" target="_blank">Return</a>
                        &nbsp;|&nbsp;
                        <a href="<?php echo base_url('index.php/PaymentGateway/voidSale/' . $payment['request_payment_id']); ?>" target="_blank">Void</a>
                        <?php } else if (isset($payment['request_payment_token']) && $payment['request_payment_status'] == 7) { ?>
                            &nbsp;|&nbsp;
                            <a href="<?php echo base_url('index.php/PaymentGateway/voidReturn/' . $payment['request_payment_id']); ?>" target="_blank">Void return</a>
                        <?php } ?>
                        <?php if (isset($payment['request_payment_sale_id'])) { ?>
                            &nbsp;|&nbsp;
                            <a href="<?php echo base_url('index.php/sales/edit/' . $payment['request_payment_sale_id']); ?>" target="_blank">Edit sale</a>
                        <?php } ?>
                    </td>
                </tr>
                <?php } ?>
                <?php } else { ?>
                    <tr>
                        <td colspan="9">
                            No payments yet.
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
        <div class="summary">
            Displaying <strong><?php echo $count; ?></strong> out of <strong><?php echo $totalCount; ?></strong> payments
            <br />Page <strong><?php echo $page; ?></strong> of <strong><?php echo $totalPages; ?></strong>
        </div>
        <?php if ($totalPages > 1) { ?>
        <div class="pagination">
            <?php if ($page > 1) { ?>
            <a href="<?php echo base_url('index.php/PaymentGateway/payments/' . ($page - 1) . (!empty($searchFilter) ? '?search_filter=' . $searchFilter : '')); ?>">&lt; Previous</a>
            <?php } ?>
            <?php if ($page < $totalPages) { ?>
                <?php if ($page > 1) { ?>
                &nbsp;|&nbsp;
                <?php } ?>
                <a href="<?php echo base_url('index.php/PaymentGateway/payments/' . ($page + 1) . (!empty($searchFilter) ? '?search_filter=' . $searchFilter : '')); ?>">Next &gt;</a>
            <?php } ?>
        </div>
        <?php } ?>
        <div>
            <a href="<?php echo base_url('index.php/PaymentGateway/'); ?>">Back</a>
        </div>
    </div>
</div>
