<?php
/**
 * @see https://hc.mercurydev.net/tws/transactionservice.asmx
 */

/**
 *
 */
interface MercuryTransactionServiceInterface
{

    /**
     * @param array $parameters                     array('request' => array, 'password' => string)
     * @return \stdClass
     * @see https://hc.mercurydev.net/tws/transactionservice.asmx?op=CreditPreAuthToken
     */
    public function CreditPreAuthToken($parameters);

    /**
     * @param array $parameters                     array('request' => array, 'password' => string)
     * @return \stdClass
     * @see https://hc.mercurydev.net/tws/transactionservice.asmx?op=CreditPreAuthCaptureToken
     */
    public function CreditPreAuthCaptureToken($parameters);

    /**
     * @param array $parameters                     array('request' => array, 'password' => string)
     * @return \stdClass
     * @see https://hc.mercurydev.net/tws/transactionservice.asmx?op=CreditSaleToken
     */
    public function CreditSaleToken($parameters);

    /**
     * @param array $parameters                     array('request' => array, 'password' => string)
     * @return \stdClass
     * @see https://hc.mercurydev.net/tws/transactionservice.asmx?op=CreditVoidSaleToken
     */
    public function CreditVoidSaleToken($parameters);

    /**
     * @param array $parameters                     array('request' => array, 'password' => string)
     * @return \stdClass
     * @see https://hc.mercurydev.net/tws/transactionservice.asmx?op=CreditReturnToken
     */
    public function CreditReturnToken($parameters);

    /**
     * @param array $parameters                     array('request' => array, 'password' => string)
     * @return \stdClass
     * @see https://hc.mercurydev.net/tws/transactionservice.asmx?op=CreditVoidReturnToken
     */
    public function CreditVoidReturnToken($parameters);

    /**
     * @param array $parameters                     array('request' => array, 'password' => string)
     * @return \stdClass
     * @see https://hc.mercurydev.net/tws/transactionservice.asmx?op=CreditReversalToken
     */
    public function CreditReversalToken($parameters);

    /**
     * @param array $parameters                     array('request' => array, 'password' => string)
     * @return \stdClass
     * @see https://hc.mercurydev.net/tws/transactionservice.asmx?op=CreditAdjustToken
     */
    public function CreditAdjustToken($parameters);

    /**
     * @param array $parameters                     array('request' => array, 'password' => string)
     * @return \stdClass
     * @see https://hc.mercurydev.net/tws/transactionservice.asmx?op=BatchClear
     */
    public function BatchClear($parameters);

    /**
     * @param array $parameters                     array('request' => array, 'password' => string)
     * @return \stdClass
     * @see https://hc.mercurydev.net/tws/transactionservice.asmx?op=BatchClose
     */
    public function BatchClose($parameters);

    /**
     * @param array $parameters                     array('request' => array, 'password' => string)
     * @return \stdClass
     * @see https://hc.mercurydev.net/tws/transactionservice.asmx?op=BatchSummary
     */
    public function BatchSummary($parameters);

}
