<?php
/**
 * @package Mercury Payment Integration
 */

/**
 *
 */
class MercuryHostedCheckoutService
{

    /**
     * @var string
     */
    const DEVELOPMENT_URL = 'https://hc.mercurydev.net/hcws/hcservice.asmx';

    /**
     * @var string
     */
    const PRODUCTION_URL = 'https://hc.mercurypay.com/hcws/hcservice.asmx';

    /**
     * @static
     * @var \MercuryHostedCheckoutServiceInterface
     */
    private static $_wsClient;

    /**
     *
     */
    public function __construct()
    {
        self::_init();
    }

    /**
     * @internal
     * @static
     */
    private static function _init()
    {
        if (!isset(self::$_wsClient)) {
            if (self::_isInDevelopment()) {
                $url = self::DEVELOPMENT_URL . '?WSDL';
            } else {
                $url = self::PRODUCTION_URL . '?WSDL';
            }

            self::$_wsClient = new SoapClient($url);

        }
    }

    /**
     * @static
     * @return bool
     */
    private static function _isInDevelopment()
    {
        return \Mercury::isTesting();
    }

    /**
     * @static
     * @return \MercuryHostedCheckoutServiceInterface
     */
    public static function getSoapClient()
    {
        self::_init();
        return self::$_wsClient;
    }

    /**
     * @param array $request
     * @return \stdClass
     */
    public function sendAcknowledgeCardInfo($request)
    {
        self::_init();
        return self::$_wsClient->AcknowledgeCardInfo(array('request' => $request));
    }

    /**
     * @param array $request
     * @return \stdClass
     */
    public function sendAcknowledgePayment($request)
    {
        self::_init();
        return self::$_wsClient->AcknowledgePayment(array('request' => $request));
    }

    /**
     * @param array $request
     * @return \stdClass
     */
    public function sendDownloadCSS($request)
    {
        self::_init();
        return self::$_wsClient->DownloadCSS(array('request' => $request));
    }

    /**
     * @param array $request
     * @return \stdClass
     */
    public function sendInitializeCardInfo($request)
    {
        self::_init();
        return self::$_wsClient->InitializeCardInfo(array('request' => $request));
    }

    /**
     * @param array $request
     * @return \stdClass
     */
    public function sendInitializePayment($request)
    {
        self::_init();
        return self::$_wsClient->InitializePayment(array('request' => $request));
    }

    /**
     * @param array $request
     * @return \stdClass
     */
    public function sendRemoveCSS($request)
    {
        self::_init();
        return self::$_wsClient->RemoveCSS(array('request' => $request));
    }

    /**
     * @param array $request
     * @return \stdClass
     */
    public function sendUploadCSS($request)
    {
        self::_init();
        return self::$_wsClient->UploadCSS(array('request' => $request));
    }

    /**
     * @param array $request
     * @return \stdClass
     */
    public function sendVerifyCardInfo($request)
    {
        self::_init();
        return self::$_wsClient->VerifyCardInfo(array('request' => $request));
    }

    /**
     * @param array $request
     * @return \stdClass
     */
    public function sendVerifyPayment($request)
    {
        self::_init();
        return self::$_wsClient->VerifyPayment(array('request' => $request));
    }

}
