<?php

/**
 *
 */
class MercuryRequestSpecificationParameter
{

    /**
     * @var int
     */
    const TYPE_STRING = 0;

    /**
     * @var int
     */
    const TYPE_NUMERIC = 1;

    /**
     * @var int
     */
    const TYPE_BOOLEAN = 2;

    /**
     * @var int
     */
    const TYPE_DOUBLE = 3;

    /**
     * @var string
     */
    public $parameter;

    /**
     * @var int
     */
    public $type;

    /**
     * @var int
     */
    public $length;

    /**
     * @var bool
     */
    public $required;

    /**
     * @param string $parameter
     * @param int $type
     * @param int $length
     * @param bool $required
     */
    public function __construct($parameter, $type, $length, $required)
    {
        $this->parameter = $parameter;
        $this->type = (int) $type;
        $this->length = (int) $length;
        $this->required = (!empty($required));
    }

}
