<?php
/**
 * Payment Gateway - Settings
 *
 * @var array $settings
 * @package Mercury Payment Integration
 */
?>
<?php $this->load->view('partial/header'); ?>
<div id="paymentgateway">
    <div id="page_title" style="margin-bottom:8px;">Mercury Payment Gateway settings</div>
    <?php if (isset($error)) { ?><div class='error_message'><?php echo $error; ?></div><?php } ?>
    <?php if (isset($warning)) { ?><div class='warning_mesage'><?php echo $warning; ?></div><?php } ?>
    <?php if (isset($success)) { ?><div class='success_message'><?php echo $success; ?></div><?php } ?>
    <div id="page_body">
        <div class="description">
            Edit form below to change settings for Mercury Payment Gateway.
        </div>
        <div>
            <form action="" method="post">
                <fieldset>
                    <div>
                        <p>
                            <label for="paymentgateway_settings_merchantid">MerchantID</label>
                        </p>
                        <input type="text" autocomplete="off" name="paymentgateway_settings[merchant_id]" id="paymentgateway_settings_merchantid" value="<?php echo (isset($settings['merchant_id']) ? $settings['merchant_id'] : ''); ?>" />
                    </div>
                    <div>
                        <p>
                            <label for="paymentgateway_settings_operatorid">OperatorID</label>
                        </p>
                        <input type="text" autocomplete="off" name="paymentgateway_settings[operator_id]" id="paymentgateway_settings_operatorid" value="<?php echo (isset($settings['operator_id']) ? $settings['operator_id'] : ''); ?>" />
                    </div>
                    <div>
                        <p>
                            <label for="paymentgateway_settings_password">Password</label>
                        </p>
                        <input type="text" autocomplete="off" name="paymentgateway_settings[password]" id="paymentgateway_settings_password" value="<?php echo (isset($settings['password']) ? $settings['password'] : ''); ?>" />
                    </div>
                    <div>
                        <p>
                            <label for="paymentgateway_settings_paymentsperpage">Payments per page</label>
                        </p>
                        <input type="text" autocomplete="off" name="paymentgateway_settings[paymentsperpage]" id="paymentgateway_settings_paymentsperpage" value="<?php echo (isset($settings['paymentsperpage']) ? $settings['paymentsperpage'] : ''); ?>" />
                    </div>
                    <div>
                        <input type="checkbox" name="paymentgateway_settings[testing_mode]" id="paymentgateway_settings_testing_mode" value="1"<?php echo (!empty($settings['testing_mode']) ? ' checked="checked"' : ''); ?>" />
                        <label for="paymentgateway_settings_testing_mode">Testing mode</label>
                    </div>
                    <div>
                        <input type="checkbox" name="paymentgateway_settings[swipe]" id="paymentgateway_settings_swipe" value="1"<?php echo (!empty($settings['swipe']) ? ' checked="checked"' : ''); ?>" />
                        <label for="paymentgateway_settings_swipe">Use swipe as default card entry method</label>
                    </div>
                    <div>
                        <input type="submit" value="Save" />
                    </div>
                </fieldset>
            </form>
        </div>
        <div>
            <?php echo anchor('PaymentGateway/', 'Back'); ?>
        </div>
    </div>
</div>
