<?php
/**
 * @see https://hc.mercurydev.net/hcws/hcservice.asmx
 */

/**
 *
 */
interface MercuryHostedCheckoutServiceInterface
{

    /**
     * @param array $parameters                         array('request' => array)
     * @return \stdClass
     * @see https://hc.mercurydev.net/hcws/hcservice.asmx?op=InitializePayment
     */
    public function InitializePayment($parameters);

    /**
     * @param array $parameters                         array('request' => array)
     * @return \stdClass
     * @see https://hc.mercurydev.net/hcws/hcservice.asmx?op=VerifyPayment
     */
    public function VerifyPayment($parameters);

    /**
     * @param array $parameters                         array('request' => array)
     * @return \stdClass
     * @see https://hc.mercurydev.net/hcws/hcservice.asmx?op=AcknowledgePayment
     */
    public function AcknowledgePayment($parameters);

    /**
     * @param array $parameters                         array('request' => array)
     * @return \stdClass
     * @see https://hc.mercurydev.net/hcws/hcservice.asmx?op=InitializeCardInfo
     */
    public function InitializeCardInfo($parameters);

    /**
     * @param array $parameters                         array('request' => array)
     * @return \stdClass
     * @see https://hc.mercurydev.net/hcws/hcservice.asmx?op=VerifyCardInfo
     */
    public function VerifyCardInfo($parameters);

    /**
     * @param array $parameters                         array('request' => array)
     * @return \stdClass
     * @see https://hc.mercurydev.net/hcws/hcservice.asmx?op=AcknowledgeCardInfo
     */
    public function AcknowledgeCardInfo($parameters);

    /**
     * @param array $parameters                         array('request' => array)
     * @return \stdClass
     * @see https://hc.mercurydev.net/hcws/hcservice.asmx?op=UploadCSS
     */
    public function UploadCSS($parameters);

    /**
     * @param array $parameters                         array('request' => array)
     * @return \stdClass
     * @see https://hc.mercurydev.net/hcws/hcservice.asmx?op=DownloadCSS
     */
    public function DownloadCSS($parameters);

    /**
     * @param array $parameters                         array('request' => array)
     * @return \stdClass
     * @see https://hc.mercurydev.net/hcws/hcservice.asmx?op=RemoveCSS
     */
    public function RemoveCSS($parameters);

}
