<?php
/**
 * @package Mercury Payment Integration
 */

/**
 *
 */
class CreditReturnTokenRequest extends MercuryRequest
{

    /**
     * @var string|null
     */
    private $_password;

    /**
     * @param array|null [$values = null]
     * @param string|null [$password = null]
     */
    public function __construct($values = null, $password = null)
    {

        $parameters = array(
            new \MercuryRequestSpecificationParameter(
                'CardHolderName',
                \MercuryRequestSpecificationParameter::TYPE_STRING,
                30,
                false
            ),
            new \MercuryRequestSpecificationParameter(
                'Frequency',
                \MercuryRequestSpecificationParameter::TYPE_STRING,
                9,
                true
            ),
            new \MercuryRequestSpecificationParameter(
                'Invoice',
                \MercuryRequestSpecificationParameter::TYPE_STRING,
                16,
                true
            ),
            new \MercuryRequestSpecificationParameter(
                'Memo',
                \MercuryRequestSpecificationParameter::TYPE_STRING,
                40,
                true
            ),
            new \MercuryRequestSpecificationParameter(
                'MerchantID',
                \MercuryRequestSpecificationParameter::TYPE_NUMERIC,
                24,
                true
            ),
            new \MercuryRequestSpecificationParameter(
                'OperatorID',
                \MercuryRequestSpecificationParameter::TYPE_STRING,
                16,
                true
            ),
            new \MercuryRequestSpecificationParameter(
                'PurchaseAmount',
                \MercuryRequestSpecificationParameter::TYPE_DOUBLE,
                8,
                true
            ),
            new \MercuryRequestSpecificationParameter(
                'TerminalName',
                \MercuryRequestSpecificationParameter::TYPE_STRING,
                20,
                false
            ),
            new \MercuryRequestSpecificationParameter(
                'Token',
                \MercuryRequestSpecificationParameter::TYPE_STRING,
                100,
                true
            ),
        );

        $specification =
            new \MercuryRequestSpecification($parameters);
        $this->_password = $password;

        parent::__construct($specification, $values);

    }

    /**
     * @return bool
     */
    public function responseWasSuccessful()
    {
        if (isset($this->_response->Status)
            && $this->_response->Status == 'Approved'
        ) {
            return true;
        }
        return false;
    }

    /**
     * @return stdClass|bool
     */
    protected function _request()
    {

        $soapClient = new \MercuryTransactionService();
        $response = $soapClient->sendCreditReturnToken(
            $this->_values, $this->_password);
        return (isset($response->CreditReturnTokenResult) ?
            $response->CreditReturnTokenResult : null);

    }

    /**
     *
     */
    protected function _requestSuccessProcess()
    {

        $response = $this->getResponse();

        $id = $response->Invoice;
        $responseRefNo = (isset($response->RefNo) ? $response->RefNo : null);
        $responseCode = (isset($response->Status) ? $response->Status : null);
        $responseMessage = (isset($response->Message) ? $response->Message : null);
        $responseAmount = (isset($response->AuthorizeAmount) ? $response->AuthorizeAmount : null);
        $responseToken = (isset($response->Token) ? $response->Token : null);
        $responseJson = json_encode($response);

        $mercuryModel = \Mercury::getInstance();

        $mercuryModel->updatePayment(
            $id,
            $mercuryModel::REQUEST_STATUS_RETURN_SALE_SUCCESS,
            null,
            $responseAmount,
            $responseToken);

        $mercuryModel->addRequest(
            $id,
            $mercuryModel::REQUEST_TYPE_RETURN_TOKEN,
            $responseCode,
            $responseMessage,
            $responseJson);

    }

    /**
     *
     */
    protected function _requestFailureProcess()
    {

        $response = $this->getResponse();

        $values = $this->getValues();
        $id = $values['Invoice'];

        $responseRefNo = (isset($response->RefNo) ? $response->RefNo : null);
        $responseCode = (isset($response->ResponseCode) ? $response->ResponseCode : null);
        $responseMessage = (isset($response->DisplayMessage) ? $response->DisplayMessage : null);
        $responseAmount = (isset($response->AuthorizeAmount) ? $response->AuthorizeAmount : null);
        $responseToken = (isset($response->Token) ? $response->Token : null);
        $responseJson = json_encode($response);

        $mercuryModel = \Mercury::getInstance();

        $mercuryModel->updatePayment(
            $id,
            $mercuryModel::REQUEST_STATUS_RETURN_SALE_FAILURE,
            null,
            $responseAmount,
            $responseToken);

        $mercuryModel->addRequest(
            $id,
            $mercuryModel::REQUEST_TYPE_RETURN_TOKEN,
            $responseCode,
            $responseMessage,
            $responseJson);

    }

}
