<?php
/**
 * @package Mercury Payment Integration
 */

/**
 *
 */
class VerifyPaymentRequest extends MercuryRequest
{

    /**
     * @param array|null [$values = null]
     */
    public function __construct($values = null)
    {

        $parameters = array(
            new \MercuryRequestSpecificationParameter(
                'MerchantID',
                \MercuryRequestSpecificationParameter::TYPE_NUMERIC,
                24,
                true
            ),
            new \MercuryRequestSpecificationParameter(
                'PaymentID',
                \MercuryRequestSpecificationParameter::TYPE_STRING,
                36,
                true
            ),
            new \MercuryRequestSpecificationParameter(
                'Password',
                \MercuryRequestSpecificationParameter::TYPE_STRING,
                16,
                true
            ),
        );

        $specification =
            new \MercuryRequestSpecification($parameters);

        parent::__construct($specification, $values);

    }

    /**
     * @return bool
     */
    public function responseWasSuccessful()
    {
        if (isset($this->_response->ResponseCode)
            && $this->_response->ResponseCode == self::RESPONSE_CODE_SUCCESS
            && !empty($this->_response->Token)
            && !empty($this->_response->CardType)
            && !empty($this->_response->MaskedAccount)
            && !empty($this->_response->Amount)
            && !empty($this->_response->TransPostTime)
            && !empty($this->_response->ExpDate)
        ) {
            return true;
        }
        return false;
    }

    /**
     * @return \stdClass|null
     */
    protected function _request()
    {

        $soapClient = new \MercuryHostedCheckoutService();
        $response = $soapClient->sendVerifyPayment($this->_values);
        return (isset($response->VerifyPaymentResult) ?
            $response->VerifyPaymentResult : null);

    }

    /**
     *
     */
    protected function _requestSuccessProcess()
    {

        $response = $this->getResponse();

        $id = $response->Invoice;
        $responseCode = $response->ResponseCode;
        $responseMessage = $response->DisplayMessage;
        $responseJson = json_encode($response);

        $mercuryModel = \Mercury::getInstance();

        $mercuryModel->updatePayment(
            $id,
            $mercuryModel::REQUEST_STATUS_VERIFIED_PAYMENT_SUCCESS,
            null,
            null,
            (isset($response->Token) ? $response->Token : null));

        $mercuryModel->addRequest(
            $id,
            $mercuryModel::REQUEST_TYPE_VERIFY_PAYMENT,
            $responseCode,
            $responseMessage,
            $responseJson);

    }

    /**
     *
     */
    protected function _requestFailureProcess()
    {

        $response = $this->getResponse();

        $id = $response->Invoice;
        $responseCode = (isset($response->ResponseCode) ? $response->ResponseCode : null);
        $responseMessage = (isset($response->DisplayMessage) ? $response->DisplayMessage : null);
        $responseJson = json_encode($response);

        $mercuryModel = \Mercury::getInstance();

        $mercuryModel->updatePayment(
            $id,
            $mercuryModel::REQUEST_STATUS_VERIFIED_PAYMENT_FAILURE,
            null,
            null,
            (isset($response->Token) ? $response->Token : null));

        $mercuryModel->addRequest(
            $id,
            $mercuryModel::REQUEST_TYPE_VERIFY_PAYMENT,
            $responseCode,
            $responseMessage,
            $responseJson);

    }

}
