<?php
/**
 *
 */

/**
 *
 */
class MercuryRequestSpecification
{

    /**
     * @var array       array of \MercuryRequestSpecificationParameter
     */
    private $_parameters;

    /**
     * @var array
     */
    private $_validationErrors;

    /**
     * @param array|null [$parameters = null]
     */
    public function __construct($parameters = null)
    {
        $this->_parameters = (is_array($parameters) ? $parameters : array());
    }

    /**
     * @param array $values
     * @return bool
     */
    public function validate($values)
    {
        $accBool = true;
        $this->_validationErrors = array();
        foreach ($this->_parameters as $parameter)
        {
            /** @var \MercuryRequestSpecificationParameter $parameter */

            if (isset($values[$parameter->parameter])) {

                $accBool = ($accBool &&
                    $this->_validateParameter($parameter,
                        $values[$parameter->parameter]));

            } else if ($parameter->required) {
                $accBool = ($accBool && false);
            }
        }

        return $accBool;

    }

    /**
     * @return array
     */
    public function getValidationErrors()
    {
        return $this->_validationErrors;
    }

    /**
     * @param string $key
     * @param string $message
     */
    public function addValidationError($key, $message)
    {
        $this->_validationErrors[$key] = $message;
    }

    /**
     * @param array $values
     * @return array
     */
    public function process($values)
    {
        $processed = array();
        foreach ($this->_parameters as $parameter)
        {
            /** @var \MercuryRequestSpecificationParameter $parameter */

            if (isset($values[$parameter->parameter])) {

                $processed[$parameter->parameter] =
                    $this->_processParameter($parameter, $values[$parameter->parameter]);

            }
        }

        return $processed;

    }

    /**
     * @param \MercuryRequestSpecificationParameter $parameter
     * @param mixed $value
     * @return mixed
     */
    private function _processParameter($parameter, $value)
    {

        $processed = $this->_processParameterType(
            $parameter, $value);
        $processed = $this->_processParameterLength(
            $parameter, $processed);
        return $processed;

    }

    /**
     * @param \MercuryRequestSpecificationParameter $parameter
     * @param mixed $value
     * @return bool
     */
    private function _processParameterType($parameter, $value)
    {
        if ($parameter->type == \MercuryRequestSpecificationParameter::TYPE_NUMERIC) {
            return (int) $value;
        } else if ($parameter->type == \MercuryRequestSpecificationParameter::TYPE_STRING) {
            return (string) $value;
        } else if ($parameter->type == \MercuryRequestSpecificationParameter::TYPE_BOOLEAN) {
            return ($value === 'true' ? 'true' : 'false');
        } else if ($parameter->type == \MercuryRequestSpecificationParameter::TYPE_DOUBLE) {
            return (double) $value;
        } else {
            return false;
        }
    }

    /**
     * @param \MercuryRequestSpecificationParameter $parameter
     * @param mixed $value
     * @return bool
     */
    private function _processParameterLength($parameter, $value)
    {
        if ($parameter->type == \MercuryRequestSpecificationParameter::TYPE_NUMERIC) {
            if (strlen((string) $value) > $parameter->length) {
                return (int) (substr((string) $value, 0, $parameter->length));
            } else {
                return $value;
            }
        } else if ($parameter->type == \MercuryRequestSpecificationParameter::TYPE_STRING) {
            if (strlen($value) > $parameter->length) {
                return substr($value, 0, $parameter->length);
            } else {
                return $value;
            }
        } else if ($parameter->type == \MercuryRequestSpecificationParameter::TYPE_BOOLEAN) {
            return $value;
        } else if ($parameter->type == \MercuryRequestSpecificationParameter::TYPE_DOUBLE) {
            return number_format($value, 2);
        } else {
            return false;
        }
    }

    /**
     * @param \MercuryRequestSpecificationParameter $parameter
     * @param mixed $value
     * @return bool
     */
    private function _validateParameter($parameter, $value)
    {
        $accBool = true;
        $accBool = ($accBool && $this->_validateParameterType(
            $parameter, $value));
        $accBool = ($accBool && $this->_validateParameterLength(
            $parameter, $value));
        if (!$accBool) {
            $this->addValidationError($parameter->parameter, 'Failed validation');
        }
        return $accBool;
    }

    /**
     * @param \MercuryRequestSpecificationParameter $type
     * @param mixed $value
     * @return bool
     */
    private function _validateParameterType($parameter, $value)
    {
        if ($parameter->type == \MercuryRequestSpecificationParameter::TYPE_NUMERIC) {
            return $this->_validateParameterTypeNumeric($value);
        } else if ($parameter->type == \MercuryRequestSpecificationParameter::TYPE_STRING) {
            return $this->_validateParameterTypeString($value);
        } else if ($parameter->type == \MercuryRequestSpecificationParameter::TYPE_BOOLEAN) {
            return $this->_validateParameterTypeBoolean($value);
        } else if ($parameter->type == \MercuryRequestSpecificationParameter::TYPE_DOUBLE) {
            return $this->_validateParameterTypeDouble($value);
        } else {
            return false;
        }
    }

    /**
     * @param mixed $value
     * @return bool
     */
    private function _validateParameterTypeNumeric($value)
    {
        if (preg_match('/^[\d]+$/', $value, $matches) === 1) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * @param mixed $value
     * @return bool
     */
    private function _validateParameterTypeDouble($value)
    {
        if (preg_match('/^[\d]+(\.[\d]{1,2}){0,1}$/', $value, $matches) === 1) {
            return true;
        } else {
            return false;
        }
    }


    /**
     * @param mixed $value
     * @return bool
     */
    private function _validateParameterTypeString($value)
    {
        return true;
    }

    /**
     * @param mixed $value
     * @return bool
     */
    private function _validateParameterTypeBoolean($value)
    {
        if ($value === 'true'
            || $value === 'false'
        ) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * @param \MercuryRequestSpecificationParameter $parameter
     * @param mixed $value
     * @return bool
     */
    private function _validateParameterLength($parameter, $value)
    {
        $strLen = (string) strlen($value);
        return ($strLen <= $parameter->length);
    }

}
