<?php
/**
 * @package Mercury Payment Integration
 */

/**
 *
 */
class HostedCheckoutRequest extends MercuryRequest
{

    /**
     * @var string|null
     */
    private $_paymentId;

    /**
     * @var string|null
     */
    private $_returnCode;

    /**
     * @var string|null
     */
    private $_returnMessage;

    /**
     * @var int
     */
    private $_invoice;

    /**
     * @param int $invoice
     * @param string|null [$paymentId = null]
     * @param string|null [$returnCode = null]
     * @param string|null [$returnMessage = null]
     */
    public function __construct($invoice, $paymentId = null,
        $returnCode = null, $returnMessage = null)
    {
        if (isset($paymentId)) {
            $this->_paymentId = $paymentId;
        }
        if (isset($returnCode)) {
            $this->_returnCode = $returnCode;
        }
        if (isset($returnMessage)) {
            $this->_returnMessage = $returnMessage;
        }
        if (isset($invoice)) {
            $this->_invoice = $invoice;
        }
        parent::__construct();
    }

    /**
     * @return bool
     */
    public function responseWasSuccessful()
    {
        if (isset($this->_response->ReturnCode)
            && $this->_response->ReturnCode == self::RESPONSE_CODE_SUCCESS
            && !empty($this->_response->PaymentID)
        ) {
            return true;
        }
        return false;
    }


    /**
     * @return \stdClass|null
     */
    protected function _request()
    {

        $response = new \stdClass();
        $response->PaymentID = $this->_paymentId;
        $response->ReturnCode = $this->_returnCode;
        $response->ReturnMessage = $this->_returnMessage;

        return $response;

    }

    /**
     *
     */
    protected function _requestSuccessProcess()
    {

        $response = $this->getResponse();

        $id = $this->_invoice;

        $responseCode = (isset($response->ReturnCode) ? $response->ReturnCode : null);
        $responseMessage = (isset($response->ReturnMessage) ? $response->ReturnMessage : null);
        $responseJson = json_encode($response);

        $mercuryModel = \Mercury::getInstance();

        $mercuryModel->updatePayment(
            $id,
            $mercuryModel::REQUEST_STATUS_HOSTED_CHECKOUT_SUCCESS);

        $mercuryModel->addRequest(
            $id,
            $mercuryModel::REQUEST_TYPE_HOSTED_CHECKOUT,
            $responseCode,
            $responseMessage,
            $responseJson);

    }

    /**
     *
     */
    protected function _requestFailureProcess()
    {

        $response = $this->getResponse();

        $id = $this->_invoice;

        $responseCode = (isset($response->ReturnCode) ? $response->ReturnCode : null);
        $responseMessage = (isset($response->ReturnMessage) ? $response->ReturnMessage : null);
        $responseJson = json_encode($response);

        $mercuryModel = \Mercury::getInstance();

        $mercuryModel->updatePayment(
            $id,
            $mercuryModel::REQUEST_STATUS_HOSTED_CHECKOUT_FAILURE);

        $mercuryModel->addRequest(
            $id,
            $mercuryModel::REQUEST_TYPE_HOSTED_CHECKOUT,
            $responseCode,
            $responseMessage,
            $responseJson);

    }

}
