<?php
/**
 * @package Mercury Payment Integration
 */

/**
 *
 */
class CreditVoidSaleTokenRequest extends MercuryRequest
{

    /**
     * @var string
     */
    private $_password;

    /**
     * @param array|null [$values = null]
     * @param string|null [$password = null]
     */
    public function __construct($values = null, $password = null)
    {

        $parameters = array(
            new \MercuryRequestSpecificationParameter(
                'AuthCode',
                \MercuryRequestSpecificationParameter::TYPE_STRING,
                16,
                true
            ),
            new \MercuryRequestSpecificationParameter(
                'CardHolderName',
                \MercuryRequestSpecificationParameter::TYPE_STRING,
                30,
                false
            ),
            new \MercuryRequestSpecificationParameter(
                'Frequency',
                \MercuryRequestSpecificationParameter::TYPE_STRING,
                9,
                true
            ),
            new \MercuryRequestSpecificationParameter(
                'Invoice',
                \MercuryRequestSpecificationParameter::TYPE_STRING,
                16,
                true
            ),
            new \MercuryRequestSpecificationParameter(
                'Memo',
                \MercuryRequestSpecificationParameter::TYPE_STRING,
                40,
                true
            ),
            new \MercuryRequestSpecificationParameter(
                'MerchantID',
                \MercuryRequestSpecificationParameter::TYPE_NUMERIC,
                24,
                true
            ),
            new \MercuryRequestSpecificationParameter(
                'OperatorID',
                \MercuryRequestSpecificationParameter::TYPE_STRING,
                16,
                true
            ),
            new \MercuryRequestSpecificationParameter(
                'PurchaseAmount',
                \MercuryRequestSpecificationParameter::TYPE_DOUBLE,
                8,
                true
            ),
            new \MercuryRequestSpecificationParameter(
                'RefNo',
                \MercuryRequestSpecificationParameter::TYPE_STRING,
                16,
                true
            ),
            new \MercuryRequestSpecificationParameter(
                'TerminalName',
                \MercuryRequestSpecificationParameter::TYPE_STRING,
                20,
                false
            ),
            new \MercuryRequestSpecificationParameter(
                'Token',
                \MercuryRequestSpecificationParameter::TYPE_STRING,
                100,
                true
            ),
        );

        $specification =
            new \MercuryRequestSpecification($parameters);

        $this->_password = $password;

        parent::__construct($specification, $values);

    }

    /**
     * @return bool
     */
    public function responseWasSuccessful()
    {
        if (isset($this->_response->Status)
            && $this->_response->Status == 'Approved'
        ) {
            return true;
        }
        return false;
    }

    /**
     * @return \stdClass|null
     */
    protected function _request()
    {

        $soapClient = new \MercuryTransactionService();
        $response = $soapClient->sendCreditVoidSaleToken(
            $this->_values, $this->_password);
        return (isset($response->CreditVoidReturnTokenResult) ?
            $response->CreditVoidReturnTokenResult : null);

    }

    /**
     *
     */
    protected function _requestSuccessProcess()
    {

        $response = $this->getResponse();

        $id = $response->Invoice;
        $responseCode = (isset($response->Status) ? $response->Status : null);
        $responseMessage = (isset($response->Message) ? $response->Message : null);
        $responseJson = json_encode($response);

        $mercuryModel = \Mercury::getInstance();

        $mercuryModel->updatePayment(
            $id,
            $mercuryModel::REQUEST_STATUS_VOID_SALE_SUCCESS);

        $mercuryModel->addRequest(
            $id,
            $mercuryModel::REQUEST_TYPE_VOID_SALE_TOKEN,
            $responseCode,
            $responseMessage,
            $responseJson);

    }

    /**
     *
     */
    protected function _requestFailureProcess()
    {

        $response = $this->getResponse();

        $values = $this->getValues();
        $id = $values['Invoice'];

        $responseCode = (isset($response->ResponseCode) ? $response->ResponseCode : null);
        $responseMessage = (isset($response->DisplayMessage) ? $response->DisplayMessage : null);

        $responseJson = json_encode($response);

        $mercuryModel = \Mercury::getInstance();
/*
        $mercuryModel->updatePayment(
            $id,
            $mercuryModel::REQUEST_STATUS_VOID_SALE_FAILURE);
*/

        $mercuryModel->addRequest(
            $id,
            $mercuryModel::REQUEST_TYPE_VOID_SALE_TOKEN,
            $responseCode,
            $responseMessage,
            $responseJson);

    }

}
